/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.DaemonAliveConstraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskClusterMgrIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String DAEMON_CHECK = s_msgBundle.getMessage("1051", false);
    static final String LSEP = System.getProperty("line.separator");
    private TaskClusterMgrIntegrity m_genTask;

    public sTaskClusterMgrIntegrity(TaskClusterMgrIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        ResultSet resultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean cssStatus = false;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("Type", "ALIVE");
        ht.put("Qualifier", "ALIVE");
        ht.put("FallbackAction", "SKIP");
        ht.put("KeyData", VDMUtil.getDaemonInternalName("ocssd"));
        String css_disp_name = VDMUtil.getDaemonDisplayName("ocssd");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4801", false));
        try {
            DaemonAliveConstraint daCon = new DaemonAliveConstraint(ht);
            cssStatus = daCon.applyConstraint(this.m_genTask.m_nodeList, resultSet);
            Hashtable rsltHt = resultSet.getResultTable();
            Enumeration e = rsltHt.keys();
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("4804", false, (Object[])new String[]{css_disp_name}));
            while (e.hasMoreElements()) {
                String curNode = (String)e.nextElement();
                Result result = (Result)rsltHt.get(curNode);
                String dmnStatus = ReportUtil.ALIVE;
                if (result.getStatus() != 1) {
                    dmnStatus = ReportUtil.NOTALIVE;
                    resultSet.addErrorDescription(curNode, errorDesc);
                }
                ReportUtil.writeRecord(curNode, dmnStatus);
            }
            if (resultSet.getStatus() == 1) {
                ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{DAEMON_CHECK, css_disp_name}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{DAEMON_CHECK, css_disp_name}));
                ReportUtil.printErrorNodes(resultSet);
            }
            this.m_genTask.getResultSet().uploadResultSet(resultSet);
        }
        catch (InvalidConstraintDataException e) {
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("4805", false));
            resultSet.addErrorDescription(errorDesc);
            ReportUtil.sureprintln("ERROR: " + e.getMessage());
            Trace.out((String)"==== InvalidConstraintDataException while checking cluster manager integrity");
        }
        boolean grandStatus = cssStatus;
        ReportUtil.sureblankln();
        if (grandStatus) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4802", false));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4803", false));
        }
        return grandStatus;
    }
}

